<?php
	include_once('define.php');
	
	require_once('nusoap/nusoap.php');
	$server = new soap_server();
	
	$server->configureWSDL('Licensing');
	$namespace = 'POSBang.LicenseManager';
	$server->wsdl->schemaTargetNamespace = $namespace;
	
//     $server->soap_defenconding = 'UTF-8' ;
// 	$server->encode_utf8 = false;
//     $server->decode_utf8 = false;
	
	function Encrypt($Value, $Password)
	{
	    
		return rtrim(
			base64_encode(
				mcrypt_encrypt(
					MCRYPT_RIJNDAEL_256,
					$Password, $Value, 
					MCRYPT_MODE_ECB, 
					mcrypt_create_iv(
						mcrypt_get_iv_size(
							MCRYPT_RIJNDAEL_256, 
							MCRYPT_MODE_ECB
						), 
						MCRYPT_RAND)
					)
				), "\0"
			);
	}
	
	function GetClientRegistration($ClientSerialKey)
	{
		$ret = null;
		
		$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
		if($conn->connect_errno == 0)
		{
			$res = $conn->query("SELECT client_name, days_counter
								FROM clients
								WHERE serial_key = '". $ClientSerialKey ."'");
								
			if(!$conn->error)
			{
				if($row = $res->fetch_assoc())
				{
					$ret = array('client_name'=>$row['client_name'],
								 'days_counter'=>$row['days_counter']);
								 
					$res->free();
				}
			}
			
			$conn->close();
		}
		
		return $ret;
	}
	
	function GetIfClientExist($ClientSerialKey)
	{
		$ret = null;
		
		$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
		if($conn->connect_errno == 0)
		{
			$res = $conn->query("SELECT client_machine_info, lic_date_start FROM licenses WHERE client_key = '". $ClientSerialKey ."'");
								
			if(!$conn->error)
			{
				if($row = $res->fetch_assoc())
				{
					$ret = array('machine_info'=>$row['client_machine_info'],
								 'date_start'=>$row['lic_date_start']);
								 
					$res->free();
				}
			}
			
			$conn->close();
		}
		
		return $ret;
	}
	
	$server->register('ValidateLicense', array('SerialKey'=>'xsd:string'),
										 array('return'=>'xsd:boolean'));
	function ValidateLicense($SerialKey)
	{
		return true;
	}
	
	$server->wsdl->addComplexType('MachineInfo', 'complexType', 'struct', 'all', '',
								  array('serial_key'=>array('name'=>'serial_key', 'type'=>'xsd:string'),
										'machine_info'=>array('name'=>'machine_info', 'type'=>'xsd:string')
								  ));
	$server->register('ActivateLicense', array('MachineInfo'=>'tns:MachineInfo'),
										 array('return'=>'xsd:string'));
				
	function ActivateLicense($MachineInfo)
	{
		$ret = '';
		
		$clientreg = GetClientRegistration($MachineInfo['serial_key']);
		
		if($clientreg != null)
		{
			$client_prev_reg_info = GetIfClientExist($MachineInfo['serial_key']);
			
			if($client_prev_reg_info != null)
			{
				$lic_date_start = date('Y-m-d',strtotime($client_prev_reg_info['date_start']));
				$lic_date_end = date('Y-m-d', strtotime($lic_date_start. ' + '. $clientreg['days_counter'] .' days'));
				
				$ret = base64_encode($lic_date_start .';'. Encrypt($client_prev_reg_info['machine_info'], '95cs2v4hBeXB9q6d') .';'. $lic_date_end);
				
				
			}
			else
			{
				 $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
				 if($conn->connect_errno == 0)
				 {
				 	$lic_date_start = date('Y-m-d');
				 	$lic_date_end = date('Y-m-d', strtotime($lic_date_start. ' + '. $clientreg['days_counter'] .' days'));
					
				 	$res = $conn->query("INSERT INTO licenses (client_key, client_machine_info, date_in, lic_date_start, lic_date_end)
				 						VALUES ('". $MachineInfo['serial_key'] ."', '". $MachineInfo['machine_info'] ."', NOW(), '". $lic_date_start ."', '". $lic_date_end ."');");
										
				 	if($conn->error == null)
				 	{
				 		$ret = base64_encode($lic_date_start .';'. Encrypt($MachineInfo['machine_info'], '95cs2v4hBeXB9q6d') .';'. $lic_date_end);
				 	}
					
				 	$conn->close();
				}
			}
		}
		
		return $ret;
	}
					 		 
	/*$POST_DATA = isset($GLOBALS['HTTP_RAW_POST_DATA']) ? $GLOBALS['HTTP_RAW_POST_DATA'] : '';
	//$server->service($POST_DATA);
	$server->service(file_get_contents("php://input"));*/
	
	if ( !isset( $HTTP_RAW_POST_DATA ) ) $HTTP_RAW_POST_DATA =file_get_contents( 'php://input' );
    $server->service($HTTP_RAW_POST_DATA);


	exit();
?>
